set autoscale 
set xtic auto 
set ytic auto 
set style line  1 lt 1 lw 1 lc rgb "#000000"
set style line  2 lt 1 lw 1 lc rgb "#FF0000"
set style line  3 lt 1 lw 3 lc rgb "#000000"

set terminal postscript portrait enhanced color  "Times" 12
 
set xlabel "Energy (units of t)" font "Times,12"
set ylabel "Intensity (states per eV)" font "Times,12"
 
set out 'FY.ps'
 
plot "XAS.dat" using ( $1):(-$3) title 'XAS' with lines ls 1,\
     "FY.dat"  using ( $1):( $2*4) title 'FY ' with lines ls 2
 
